/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.structures.spawn_criteria;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.silverminer.shrines.registries.SpawnCriteriaTypeRegistry;
import com.silverminer.shrines.structures.spawn_criteria.SpawnCriteria;
import com.silverminer.shrines.structures.spawn_criteria.SpawnCriteriaType;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;

public class RandomChanceSpawnCriteria
extends SpawnCriteria {
    public static final Codec<RandomChanceSpawnCriteria> CODEC = RecordCodecBuilder.create(randomChanceSpawnCriteriaInstance -> randomChanceSpawnCriteriaInstance.group((App)Codec.doubleRange((double)0.0, (double)1.0).fieldOf("spawn_chance").forGetter(RandomChanceSpawnCriteria::getSpawnChance)).apply((Applicative)randomChanceSpawnCriteriaInstance, RandomChanceSpawnCriteria::new));
    private final double spawnChance;

    public RandomChanceSpawnCriteria(double spawnChance) {
        this.spawnChance = spawnChance;
    }

    @Override
    public SpawnCriteriaType getType() {
        return (SpawnCriteriaType)((Object)SpawnCriteriaTypeRegistry.RANDOM_CHANCE.get());
    }

    @Override
    public boolean test(ChunkGenerator chunkGenerator, BiomeSource biomeSource, long seed, ChunkPos chunkPos, LevelHeightAccessor heightAccessor, Predicate<Holder<Biome>> validBiome, StructureManager structureManager, RegistryAccess registryAccess) {
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(seed));
        worldgenrandom.m_190068_(seed, chunkPos.f_45578_, chunkPos.f_45579_);
        return worldgenrandom.nextDouble() < this.getSpawnChance();
    }

    protected double getSpawnChance() {
        return this.spawnChance;
    }
}

